#!/bin/sh

# The value of OOM_DISABLE is defined in linux kernel source code
OOM_DISABLE=-17

if [ $# -ne 1 ]; then
    echo "$0:Wrong argument."
    exit 1
fi

pid=$1
if [ ! -d /proc/$pid ]; then
    echo "$0:Pid $pid not exist."
    exit 1
fi

tids=`ls /proc/$pid/task`

for tid in $tids; do
    echo $OOM_DISABLE > /proc/$tid/oom_adj
done

exit 0

